import os

from ledfx.consts import LEDFX_ASSETS_PATH

ledfx_presets = {
    "digitalrain2d": {
        "matrix-fat": {
            "config": {
                "add_speed": 10.1,
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0.0,
                "brightness": 1.0,
                "count": 2.0,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "gradient": "linear-gradient(90deg, #003f0e 0.00%,#005d12 38.00%,#00ff70 52.00%,#015d29 66.00%,#06c500 100.00%)",
                "gradient_roll": 0.0,
                "impulse_decay": 0.15,
                "mirror": False,
                "multiplier": 4.0,
                "rotate": 0,
                "run_seconds": 3.0,
                "tail": 40,
                "test": False,
                "width": 4,
            },
            "name": "Matrix Fat",
        },
        "matrix-tint": {
            "config": {
                "add_speed": 30.0,
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0.0,
                "brightness": 1.0,
                "count": 1.0,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "gradient": "linear-gradient(90deg, #00ff00 0.00%,#228b22 50.00%,#ff7800 100.00%)",
                "gradient_roll": 0.0,
                "impulse_decay": 0.1,
                "mirror": False,
                "multiplier": 3.0,
                "rotate": 0,
                "run_seconds": 2.0,
                "tail": 39,
                "test": False,
                "width": 3,
            },
            "name": "Matrix Tint",
        },
        "rainbow": {
            "config": {
                "add_speed": 10.3,
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0.0,
                "brightness": 1.0,
                "count": 2.0,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "gradient": "linear-gradient(90deg, #ff0000 0.00%,#ff7800 14.00%,#ffc800 28.00%,#00ff00 42.00%,#00c78c 56.00%,#0000ff 70.00%,#800080 84.00%,#ff00b2 98.00%)",
                "gradient_roll": 0.0,
                "impulse_decay": 0.15,
                "mirror": False,
                "multiplier": 4.0,
                "rotate": 0,
                "run_seconds": 3.0,
                "tail": 50,
                "test": False,
                "width": 10,
            },
            "name": "rainbow",
        },
        "rgb": {
            "config": {
                "add_speed": 10.3,
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0.0,
                "brightness": 1.0,
                "count": 2.0,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "gradient": "linear-gradient(90deg, #f80303 0.00%,#550000 35.00%,#00ff00 36.00%,#005d04 70.00%,#0400ff 71.00%,#01006d 100.00%)",
                "gradient_roll": 0.0,
                "impulse_decay": 0.15,
                "mirror": False,
                "multiplier": 4.0,
                "rotate": 0,
                "run_seconds": 3.0,
                "tail": 50,
                "test": False,
                "width": 3,
            },
            "name": "RGB",
        },
        "snowfield": {
            "config": {
                "add_speed": 10.1,
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0.0,
                "brightness": 1.0,
                "count": 2.1,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "gradient": "linear-gradient(90deg, #000000 1.00%,#ffffff 100.00%)",
                "gradient_roll": 0.0,
                "impulse_decay": 0.15,
                "mirror": False,
                "multiplier": 4.0,
                "rotate": 0,
                "run_seconds": 3.0,
                "tail": 50,
                "test": False,
                "width": 30,
            },
            "name": "snowfield",
        },
    },
    "noise2d": {
        "acid": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0.0,
                "brightness": 1.0,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "gradient": "linear-gradient(90deg, #000000 45.00%,#1aff00 57.00%,#000000 70.00%)",
                "gradient_roll": 0.0,
                "impulse_decay": 0.06,
                "intensity": 128,
                "mirror": False,
                "multiplier": 2.0,
                "rotate": 0,
                "soap": False,
                "speed": 1.0,
                "stretch": 1.5,
                "test": False,
                "zoom": 2.0,
            },
            "name": "acid",
        },
        "blood": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0.0,
                "brightness": 1.0,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "gradient": "linear-gradient(90deg, #000000 20.00%,#ff2800 41.00%,#000000 68.00%,#ff0000 100.00%)",
                "gradient_roll": 0.0,
                "impulse_decay": 0.06,
                "intensity": 128,
                "mirror": False,
                "multiplier": 2.0,
                "rotate": 0,
                "soap": False,
                "speed": 1.0,
                "stretch": 1.5,
                "test": False,
                "zoom": 2.0,
            },
            "name": "blood",
        },
        "rgb": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0.0,
                "brightness": 1.0,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "gradient": "linear-gradient(90deg, #000000 20.00%,#0016ff 31.00%,#000000 43.00%,#f60202 55.00%,#000000 66.00%,#1afc01 77.00%,#000000 87.00%)",
                "gradient_roll": 0.0,
                "impulse_decay": 0.06,
                "intensity": 128,
                "mirror": False,
                "multiplier": 2.0,
                "rotate": 0,
                "soap": False,
                "speed": 1.0,
                "stretch": 1.5,
                "test": False,
                "zoom": 2.0,
            },
            "name": "RGB",
        },
    },
    "template2d": {
        "test": {
            "config": {
                "a_switch": False,
                "advanced": True,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0.0,
                "brightness": 1.0,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "mirror": False,
                "rotate": 0,
                "test": True,
            },
            "name": "test",
        },
    },
    "equalizer2d": {
        "earth": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "bands": 64,
                "blur": 0.0,
                "brightness": 1.0,
                "center": False,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "frequency_range": "Lows (beat+bass)",
                "gradient": "linear-gradient(90deg, #00ffff 0.00%,#0000ff 32.00%,#e8f7f8 56.00%,#0aff00 97.00%)",
                "gradient_roll": 0.0,
                "max_vs_mean": False,
                "mirror": False,
                "peak_decay": 0.03,
                "peak_marks": True,
                "peak_percent": 1,
                "ring": True,
                "rotate": 2,
                "spin": True,
                "spin_decay": 0.1,
                "spin_multiplier": 1.0,
                "test": False,
            },
            "name": "earth",
        },
        "flare": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "bands": 32,
                "blur": 0.0,
                "brightness": 1.0,
                "center": True,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "frequency_range": "Lows (beat+bass)",
                "gradient": "linear-gradient(90deg, #f4f4f4 0.00%,#ffc800 25.00%,#ff7800 50.00%,#ff2800 75.00%,#ff0000 100.00%)",
                "gradient_roll": 0.0,
                "max_vs_mean": False,
                "mirror": False,
                "peak_decay": 0.03,
                "peak_marks": False,
                "peak_percent": 1,
                "ring": True,
                "rotate": 2,
                "spin": True,
                "spin_decay": 0.07,
                "spin_multiplier": 3.7,
                "test": False,
            },
            "name": "flare",
        },
        "mountain": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "bands": 16,
                "blur": 0.0,
                "brightness": 1.0,
                "center": False,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "frequency_range": "Lows (beat+bass)",
                "gradient": "linear-gradient(90deg, #ffffff 0.00%,#8dd2d2 14.00%,#edebe6 27.00%,#edca70 39.00%,#3b2d0a 60.00%,#1eea2e 72.00%,#49b752 87.00%,#0000ff 100.00%)",
                "gradient_roll": 0.0,
                "max_vs_mean": False,
                "mirror": False,
                "peak_decay": 0.03,
                "peak_marks": True,
                "peak_percent": 1,
                "ring": False,
                "rotate": 2,
                "spin": True,
                "spin_decay": 0.1,
                "spin_multiplier": 1.0,
                "test": False,
            },
            "name": "mountain",
        },
        "neon": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "bands": 16,
                "blur": 0.0,
                "brightness": 1.0,
                "center": True,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "frequency_range": "Lows (beat+bass)",
                "gradient": "linear-gradient(90deg, #0000ff 0.00%,#00ffff 33.00%,#800080 66.00%,#ff00b2 99.00%)",
                "gradient_roll": 0.0,
                "max_vs_mean": False,
                "mirror": False,
                "peak_decay": 0.03,
                "peak_marks": False,
                "peak_percent": 1,
                "ring": False,
                "rotate": 1,
                "spin": True,
                "spin_decay": 0.1,
                "spin_multiplier": 1.0,
                "test": False,
            },
            "name": "neon",
        },
    },
    "keybeat2d": {
        "beat-cat": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "beat_frames": "2 7 12 18 23 29 33 38 42 47 51 57 61",
                "blur": 0.0,
                "brightness": 1.0,
                "center_horizontal": 0,
                "center_vertical": 0,
                "diag": False,
                "deep_diag": False,
                "dump": False,
                "fake_beat": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "keep_aspect_ratio": False,
                "force_fit": True,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "catfixed.gif"
                ),
                "mirror": False,
                "ping_pong": False,
                "rotate": 0,
                "skip_frames": "",
                "stretch_horizontal": 55,
                "stretch_vertical": 57,
                "test": False,
                "resize_method": "Slow",
                "half_beat": False,
                "ping_pong_skip": False,
            },
            "name": "beat cat",
        },
        "blade": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "beat_frames": "0 10 20 30 40 54 65 75 83 92 103 110 120 130 140 150 159 170 178 188 198 213 222 225 228 231",
                "blur": 0.0,
                "brightness": 1.0,
                "center_horizontal": 1,
                "center_vertical": 1,
                "diag": False,
                "deep_diag": False,
                "dump": False,
                "fake_beat": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "keep_aspect_ratio": True,
                "force_fit": True,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "blade.webp"
                ),
                "half_beat": True,
                "mirror": False,
                "ping_pong": False,
                "ping_pong_skip": False,
                "rotate": 0,
                "skip_frames": "",
                "stretch_horizontal": 66,
                "stretch_vertical": 67,
                "test": False,
                "resize_method": "Slow",
                "half_beat": False,
            },
            "name": "blade",
        },
        "bruce": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "beat_frames": "0 12 20 30 41 57 72 82 96 107 119 127",
                "blur": 0.0,
                "brightness": 0.79,
                "center_horizontal": 0,
                "center_vertical": 0,
                "crazy": False,
                "diag": False,
                "deep_diag": False,
                "dump": False,
                "fake_beat": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "keep_aspect_ratio": True,
                "force_fit": True,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "bruces1.gif"
                ),
                "mirror": False,
                "ping_pong": True,
                "rotate": 0,
                "skip_frames": "",
                "stretch_horizontal": 105,
                "stretch_vertical": 100,
                "test": False,
                "resize_method": "Slow",
                "half_beat": False,
                "ping_pong_skip": False,
            },
            "name": "bruce",
        },
        "bumble": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "beat_frames": "0 9 19 29 39 49 57",
                "blur": 0.0,
                "brightness": 0.79,
                "center_horizontal": 0,
                "center_vertical": 0,
                "crazy": False,
                "diag": False,
                "deep_diag": False,
                "dump": False,
                "fake_beat": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "keep_aspect_ratio": False,
                "force_fit": False,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "bumble.gif"
                ),
                "mirror": False,
                "ping_pong": True,
                "ping_pong_skip": False,
                "rotate": 0,
                "skip_frames": "",
                "stretch_horizontal": 100,
                "stretch_vertical": 100,
                "test": False,
                "resize_method": "Slow",
                "half_beat": False,
            },
            "name": "bumble",
        },
        "caddyshack": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "beat_frames": "8 18 29 41 50 60 70 80 90 98 106 114 125 135 142 150 160 170 180 190 197 207",
                "blur": 0.0,
                "brightness": 1.0,
                "center_horizontal": 0,
                "center_vertical": 0,
                "diag": False,
                "deep_diag": False,
                "dump": False,
                "fake_beat": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "keep_aspect_ratio": True,
                "force_fit": True,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "caddy.gif"
                ),
                "half_beat": False,
                "mirror": False,
                "ping_pong": True,
                "ping_pong_skip": False,
                "resize_method": "Slow",
                "rotate": 0,
                "skip_frames": "",
                "stretch_horizontal": 100,
                "stretch_vertical": 100,
                "test": False,
            },
            "name": "caddyshack",
        },
        "dance": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "beat_frames": "4 0",
                "blur": 0.0,
                "brightness": 1.0,
                "center_horizontal": 0,
                "center_vertical": 0,
                "diag": False,
                "deep_diag": False,
                "dump": False,
                "fake_beat": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "keep_aspect_ratio": True,
                "force_fit": True,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "dancing.gif"
                ),
                "mirror": False,
                "ping_pong": False,
                "rotate": 0,
                "skip_frames": "",
                "stretch_horizontal": 55,
                "stretch_vertical": 57,
                "test": False,
                "resize_method": "Slow",
                "half_beat": False,
                "ping_pong_skip": False,
            },
            "name": "dance",
        },
        "dj bird": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "beat_frames": "",
                "blur": 0.0,
                "brightness": 1.0,
                "center_horizontal": 0,
                "center_vertical": 0,
                "diag": False,
                "deep_diag": False,
                "dump": False,
                "fake_beat": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "keep_aspect_ratio": False,
                "force_fit": True,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "pixelart", "dj_bird.gif"
                ),
                "half_beat": False,
                "mirror": False,
                "ping_pong": False,
                "ping_pong_skip": False,
                "rotate": 0,
                "skip_frames": "",
                "stretch_horizontal": 100,
                "stretch_vertical": 100,
                "test": False,
                "resize_method": "Slow",
                "half_beat": False,
            },
            "name": "dj bird",
        },
        "moonman": {
            "config": {
                "advanced": False,
                "background_brightness": 1,
                "background_color": "#000000",
                "beat_frames": "0 7 13",
                "blur": 0,
                "brightness": 1,
                "center_horizontal": 1,
                "center_vertical": 1,
                "diag": False,
                "deep_diag": False,
                "dump": False,
                "fake_beat": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "keep_aspect_ratio": True,
                "force_fit": True,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "moonman.gif"
                ),
                "mirror": False,
                "ping_pong": True,
                "ping_pong_skip": False,
                "rotate": 0,
                "skip_frames": "",
                "stretch_horizontal": 66,
                "stretch_vertical": 67,
                "test": False,
                "resize_method": "Slow",
                "half_beat": False,
            },
            "name": "MOONMAN",
        },
        "nyan": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "beat_frames": "3 8",
                "blur": 0.0,
                "brightness": 1.0,
                "center_horizontal": 0,
                "center_vertical": 0,
                "diag": False,
                "deep_diag": False,
                "dump": False,
                "fake_beat": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "keep_aspect_ratio": False,
                "force_fit": True,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "cat-space.gif"
                ),
                "mirror": False,
                "ping_pong": False,
                "rotate": 0,
                "skip_frames": "",
                "stretch_horizontal": 55,
                "stretch_vertical": 57,
                "test": False,
                "resize_method": "Slow",
                "half_beat": False,
                "ping_pong_skip": False,
            },
            "name": "nyan",
        },
        "phoebe": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "beat_frames": "3  15",
                "blur": 0.0,
                "brightness": 1.0,
                "center_horizontal": 0,
                "center_vertical": 0,
                "crazy": False,
                "diag": False,
                "deep_diag": False,
                "dump": False,
                "fake_beat": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "keep_aspect_ratio": False,
                "force_fit": False,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "phoebe.gif"
                ),
                "mirror": False,
                "ping_pong": True,
                "ping_pong_skip": False,
                "rotate": 0,
                "skip_frames": "",
                "stretch_horizontal": 105,
                "stretch_vertical": 100,
                "test": False,
                "resize_method": "Slow",
                "half_beat": False,
            },
            "name": "phoebe",
        },
        "saturday": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "beat_frames": "0 9 19 27 37 47 57 66 75 85 95 105 113 124 134 145 155 165 176 186 196 205 214 224 234 246 257 267 276",
                "blur": 0.0,
                "brightness": 1.0,
                "center_horizontal": 0,
                "center_vertical": 0,
                "deep_diag": False,
                "diag": False,
                "dump": False,
                "fake_beat": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "force_fit": True,
                "half_beat": False,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "saturday.webp"
                ),
                "keep_aspect_ratio": False,
                "mirror": False,
                "ping_pong": True,
                "ping_pong_skip": False,
                "resize_method": "Slow",
                "rotate": 0,
                "skip_frames": "",
                "stretch_horizontal": 100,
                "stretch_vertical": 100,
                "test": False,
            },
            "name": "saturday",
        },
        "snoopy": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "beat_frames": "7 17 27 36 45",
                "blur": 0.0,
                "brightness": 1.0,
                "center_horizontal": 0,
                "center_vertical": 0,
                "diag": False,
                "deep_diag": False,
                "dump": False,
                "fake_beat": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "keep_aspect_ratio": False,
                "force_fit": True,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "snoopy.gif"
                ),
                "mirror": False,
                "ping_pong": False,
                "rotate": 0,
                "skip_frames": "1",
                "stretch_horizontal": 55,
                "stretch_vertical": 57,
                "test": False,
                "resize_method": "Slow",
                "half_beat": False,
                "ping_pong_skip": False,
            },
            "name": "snoopy",
        },
        "sponge": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "beat_frames": "0 4",
                "blur": 0.0,
                "brightness": 1.0,
                "center_horizontal": 0,
                "center_vertical": 0,
                "crazy": False,
                "diag": False,
                "deep_diag": False,
                "dump": False,
                "fake_beat": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "keep_aspect_ratio": True,
                "force_fit": True,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "sponge.gif"
                ),
                "mirror": False,
                "ping_pong": False,
                "rotate": 0,
                "skip_frames": "",
                "stretch_horizontal": 105,
                "stretch_vertical": 100,
                "test": False,
                "resize_method": "Slow",
                "half_beat": False,
                "ping_pong_skip": False,
            },
            "name": "sponge",
        },
        "zilla": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "beat_frames": "2 7 10 15 21",
                "blur": 0.0,
                "brightness": 0.79,
                "center_horizontal": 0,
                "center_vertical": 0,
                "crazy": False,
                "diag": False,
                "deep_diag": False,
                "dump": False,
                "fake_beat": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "keep_aspect_ratio": True,
                "force_fit": True,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "zilla1.gif"
                ),
                "mirror": False,
                "ping_pong": False,
                "rotate": 0,
                "skip_frames": "",
                "stretch_horizontal": 105,
                "stretch_vertical": 100,
                "test": False,
                "resize_method": "Slow",
                "half_beat": False,
                "ping_pong_skip": False,
            },
            "name": "zilla",
        },
    },
    "plasma2d": {
        "aprilnight": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0.0,
                "brightness": 1.0,
                "density": 0.7,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "frequency_range": "Bass",
                "gradient": "linear-gradient(90deg, #000000 0.00%,#000000 3.00%,#05a9af 9.00%,#000000 15.00%,#000000 23.00%,#2daf1f 29.00%,#000000 35.00%,#000000 43.00%,#f99605 49.00%,#000000 56.00%,#000000 63.00%,#ff5c00 69.00%,#000000 75.00%,#000000 83.00%,#df2d48 89.00%,#000000 95.00%,#000000 100.00%)",
                "gradient_roll": 0.0,
                "lower": 0.83,
                "mirror": False,
                "radius": 0.2,
                "rotate_t": 0,
                "test": False,
                "twist": 0.07,
                "v density": 0.1,
            },
            "name": "AprilNight",
        },
    },
    "plasmawled": {
        "snowcrash": {
            "config": {
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0.0,
                "brightness": 1.0,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "frequency_range": "Lows (beat+bass)",
                "gradient": "linear-gradient(90deg, #000000 1.00%,#ffffff 100.00%)",
                "gradient_roll": 0.0,
                "h_stretch": 28,
                "mirror": False,
                "multiplier": 0.83,
                "rotate_t": 0,
                "size x": 0.7,
                "speed": 28,
                "speed x": 0.0,
                "test": False,
                "v_stretch": 30,
            },
            "name": "Snow Crash",
        },
    },
    "bar": {
        "bouncing-blues": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color_step": 0.125,
                "ease_method": "ease_in",
                "flip": True,
                "gradient_name": "Winter",
                "gradient": "linear-gradient(90deg, rgb(0, 199, 140) 0%, rgb(0, 255, 50) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": True,
                "mode": "bounce",
            },
            "name": "Bouncing Blues",
        },
        "passing-by": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 2.8,
                "brightness": 1,
                "color_step": 0.3,
                "ease_method": "linear",
                "flip": True,
                "gradient_name": "Borealis",
                "gradient": "linear-gradient(90deg, rgb(255, 40, 0) 0%, rgb(128, 0, 128) 33%, rgb(0, 199, 140) 66%, rgb(0, 255, 0) 99%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "mode": "wipe",
                "solid_color": False,
            },
            "name": "Passing By",
        },
        "plasma-cascade": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color_step": 0.125,
                "ease_method": "ease_out",
                "flip": True,
                "gradient_name": "Plasma",
                "gradient": "linear-gradient(90deg, rgb(0, 0, 255) 0%, rgb(128, 0, 128) 25%, rgb(255, 0, 0) 50%, rgb(255, 40, 0) 75%, rgb(255, 200, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": True,
                "mode": "wipe",
            },
            "name": "Plasma Cascade",
        },
        "smooth-bounce": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 7.9,
                "brightness": 1,
                "color_step": 0.18,
                "ease_method": "ease_in_out",
                "flip": True,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 3,
                "mirror": True,
                "mode": "bounce",
            },
            "name": "Smooth Bounce",
        },
        "Rainbow-lr": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color_step": 0.125,
                "ease_method": "ease_out",
                "flip": False,
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "mode": "wipe",
            },
            "name": "Rainbow LR",
        },
    },
    "energy": {
        "clear-sky": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 0.5,
                "brightness": 1,
                "color_cycler": False,
                "color_high": "#00ffff",
                "color_lows": "#ffc800",
                "color_mids": "#00ff00",
                "flip": False,
                "mirror": True,
                "mixing_mode": "overlap",
                "sensitivity": 0.65,
            },
            "name": "Clear Sky",
        },
        "smooth-plasma": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 8.3,
                "brightness": 1,
                "color_cycler": False,
                "color_high": "#ff0000",
                "color_lows": "#0000ff",
                "color_mids": "#ff00b2",
                "flip": False,
                "mirror": True,
                "mixing_mode": "overlap",
                "sensitivity": 0.4,
            },
            "name": "Smooth Plasma",
        },
        "smooth-rainbow": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "block_count": 4,
                "blur": 7.9,
                "brightness": 1,
                "color_cycler": False,
                "color_high": "#0000ff",
                "color_lows": "#ff0000",
                "color_mids": "#00ff00",
                "color_step": 0.18,
                "ease_method": "ease_in_out",
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_roll": 3,
                "mirror": True,
                "mixing_mode": "overlap",
                "mode": "bounce",
                "sensitivity": 0.7,
            },
            "name": "Smooth Rainbow",
        },
        "snappy-blues": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 1.2,
                "brightness": 1,
                "color_cycler": False,
                "color_high": "#00ff00",
                "color_lows": "#0000ff",
                "color_mids": "#00ffff",
                "flip": True,
                "mirror": True,
                "mixing_mode": "additive",
                "sensitivity": 0.9,
            },
            "name": "Snappy Blues",
        },
    },
    "fade": {
        "blues": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 4.5,
                "brightness": 1,
                "flip": True,
                "gradient_name": "Ocean",
                "gradient": "linear-gradient(90deg, rgb(0, 255, 255) 0%, rgb(0, 0, 255) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": False,
                "speed": 5,
            },
            "name": "Blues",
        },
        "calm-reds": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 4.5,
                "brightness": 1,
                "flip": True,
                "gradient_name": "Rust",
                "gradient": "linear-gradient(90deg, rgb(255, 40, 0) 0%, rgb(255, 0, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": False,
                "speed": 5,
            },
            "name": "Calm Reds",
        },
        "rainbow-cycle": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 4.5,
                "brightness": 1,
                "flip": True,
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": False,
                "speed": 5,
            },
            "name": "Rainbow Cycle",
        },
        "red-to-blue": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 4.5,
                "brightness": 1,
                "flip": True,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": False,
                "speed": 4.9,
            },
            "name": "Red to Blue",
        },
        "sunset": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 4.5,
                "brightness": 1,
                "flip": True,
                "gradient_name": "Sunset",
                "gradient": "linear-gradient(90deg, rgb(0, 0, 128) 0%, rgb(255, 120, 0) 50%, rgb(255, 0, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": False,
                "speed": 5,
            },
            "name": "Sunset",
        },
    },
    "gradient": {
        "breathing": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 0.41,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Viridis",
                "gradient": "linear-gradient(90deg, rgb(128, 0, 128) 0%, rgb(0, 0, 255) 25%, rgb(0, 128, 128) 50%, rgb(0, 255, 0) 75%, rgb(255, 200, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 6,
                "mirror": True,
                "modulate": True,
                "modulation_effect": "breath",
                "modulation_speed": 0.59,
                "speed": 0.41,
            },
            "name": "Breathing",
        },
        "falling-blues": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 4,
                "brightness": 1,
                "flip": True,
                "gradient_name": "Ocean",
                "gradient": "linear-gradient(90deg, rgb(0, 255, 255) 0%, rgb(0, 0, 255) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 4,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "breath",
                "modulation_speed": 0.12,
                "speed": 2.8,
            },
            "name": "Falling Blues",
        },
        "rolling-sunset": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 8.6,
                "brightness": 1,
                "flip": True,
                "gradient_name": "Sunset",
                "gradient": "linear-gradient(90deg, rgb(0, 0, 128) 0%, rgb(255, 120, 0) 50%, rgb(255, 0, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 4,
                "mirror": False,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 1,
            },
            "name": "Rolling Sunset",
        },
        "Rainbow-roll": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 0.24,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": True,
                "modulate": True,
                "modulation_effect": "sine",
                "modulation_speed": 0.97,
                "speed": 5.6,
            },
            "name": "Rainbow Roll",
        },
        "spectrum": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 0.24,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.97,
                "speed": 5.6,
            },
            "name": "Spectrum",
        },
        "twister": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 9.3,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Viridis",
                "gradient": "linear-gradient(90deg, rgb(128, 0, 128) 0%, rgb(0, 0, 255) 25%, rgb(0, 128, 128) 50%, rgb(0, 255, 0) 75%, rgb(255, 200, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 7,
                "mirror": False,
                "modulate": True,
                "modulation_effect": "breath",
                "modulation_speed": 0.34,
                "speed": 6.7,
            },
            "name": "Twister",
        },
        "waves": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 6.2,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Spring",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 178) 0%, rgb(255, 40, 0) 50%, rgb(255, 200, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 3,
                "mirror": True,
                "modulate": True,
                "modulation_effect": "sine",
                "modulation_speed": 0.52,
                "speed": 6.4,
            },
            "name": "Waves",
        },
    },
    "magnitude": {
        "cold-fire": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 1.3,
                "brightness": 1,
                "flip": False,
                "frequency_range": "Bass",
                "gradient_name": "Frost",
                "gradient": "linear-gradient(90deg, rgb(0, 0, 255) 0%, rgb(0, 255, 255) 33%, rgb(128, 0, 128) 66%, rgb(255, 0, 178) 99%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 5,
                "mirror": True,
            },
            "name": "Cold Fire",
        },
        "jungle-cascade": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 8.4,
                "brightness": 1,
                "flip": True,
                "frequency_range": "Bass",
                "gradient_name": "Jungle",
                "gradient": "linear-gradient(90deg, rgb(0, 255, 0) 0%, rgb(34, 139, 34) 50%, rgb(255, 120, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 4,
                "mirror": True,
            },
            "name": "Jungle Cascade",
        },
        "lively": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 2.3,
                "brightness": 1,
                "flip": True,
                "frequency_range": "Bass",
                "gradient_name": "Viridis",
                "gradient": "linear-gradient(90deg, rgb(128, 0, 128) 0%, rgb(0, 0, 255) 25%, rgb(0, 128, 128) 50%, rgb(0, 255, 0) 75%, rgb(255, 200, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 7,
                "mirror": True,
            },
            "name": "Lively",
        },
        "rolling-rainbow": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 5.4,
                "brightness": 1,
                "flip": False,
                "frequency_range": "Bass",
                "gradient_name": "Borealis",
                "gradient": "linear-gradient(90deg, rgb(255, 40, 0) 0%, rgb(128, 0, 128) 33%, rgb(0, 199, 140) 66%, rgb(0, 255, 0) 99%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 5,
                "mirror": False,
            },
            "name": "Rolling Rainbow",
        },
        "warm-bass": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 8.5,
                "brightness": 1,
                "flip": False,
                "frequency_range": "Bass",
                "gradient_name": "Winamp",
                "gradient": "linear-gradient(90deg, rgb(0, 255, 0) 0%, rgb(255, 200, 0) 25%, rgb(255, 120, 0) 50%, rgb(255, 40, 0) 75%, rgb(255, 0, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": False,
            },
            "name": "Warm Bass",
        },
    },
    "multiBar": {
        "bright-cascade": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 3.8,
                "brightness": 1,
                "color_step": 0.41,
                "ease_method": "linear",
                "flip": True,
                "gradient_name": "Borealis",
                "gradient": "linear-gradient(90deg, rgb(255, 40, 0) 0%, rgb(128, 0, 128) 33%, rgb(0, 199, 140) 66%, rgb(0, 255, 0) 99%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 7,
                "mirror": True,
                "mode": "cascade",
            },
            "name": "Bright Cascade",
        },
        "falling-blues": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 9.1,
                "brightness": 1,
                "color_step": 0.2,
                "ease_method": "ease_in",
                "flip": False,
                "gradient_name": "Ocean",
                "gradient": "linear-gradient(90deg, rgb(0, 255, 255) 0%, rgb(0, 0, 255) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "mode": "cascade",
            },
            "name": "Falling Blues",
        },
        "red-blue-expanse": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 3.8,
                "brightness": 1,
                "color_step": 0.41,
                "ease_method": "ease_out",
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 7,
                "mirror": True,
                "mode": "cascade",
            },
            "name": "Red Blue Expanse",
        },
        "Rainbow-oscillation": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color_step": 0.125,
                "ease_method": "ease_in_out",
                "flip": False,
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "mode": "wipe",
            },
            "name": "Rainbow Oscillation",
        },
    },
    "rain": {
        "cold-drops": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 1.0,
                "brightness": 1.0,
                "flip": False,
                "high_color": "#ff00b2",
                "high_sensitivity": 0.1,
                "lows_color": "#ffffff",
                "lows_sensitivity": 0.1,
                "mids_color": "#00ffff",
                "mids_sensitivity": 0.05,
                "mirror": True,
                "raindrop_animation": "Laser",
            },
            "name": "Cold Drops",
        },
        "meteor-shower": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 2.3,
                "brightness": 1,
                "flip": False,
                "high_color": "#ffc800",
                "high_sensitivity": 0.1,
                "lows_color": "#ff0000",
                "lows_sensitivity": 0.1,
                "mids_color": "#ffa500",
                "mids_sensitivity": 0.05,
                "mirror": False,
                "raindrop_animation": "Blob",
            },
            "name": "Meteor Shower",
        },
        "prismatic": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 4.9,
                "brightness": 1,
                "flip": False,
                "high_color": "#ff00b2",
                "high_sensitivity": 0.1,
                "lows_color": "#ffa500",
                "lows_sensitivity": 0.1,
                "mids_color": "#00ff00",
                "mids_sensitivity": 0.05,
                "mirror": True,
                "raindrop_animation": "Laser",
            },
            "name": "Prismatic",
        },
        "ripples": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0.8,
                "brightness": 1,
                "flip": False,
                "high_color": "#00ffff",
                "high_sensitivity": 0.1,
                "lows_color": "#ffc800",
                "lows_sensitivity": 0.1,
                "mids_color": "yellow-acid",
                "mids_sensitivity": 0.05,
                "mirror": True,
                "raindrop_animation": "Ripple",
            },
            "name": "Ripples",
        },
        "smooth-rwb": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 9.8,
                "brightness": 1,
                "fade_rate": 0.7,
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_roll": 8,
                "high_color": "#0000ff",
                "high_sensitivity": 0.1,
                "lows_color": "#ffffff",
                "lows_sensitivity": 0.1,
                "mids_color": "#ff0000",
                "mids_sensitivity": 0.05,
                "mirror": False,
                "raindrop_animation": "Ripple",
                "responsiveness": 0.88,
            },
            "name": "Smooth RWB",
        },
    },
    "rainbow": {
        "cascade": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 7.7,
                "brightness": 1,
                "flip": False,
                "frequency": 0.32,
                "mirror": True,
                "speed": 0.3,
            },
            "name": "Cascade",
        },
        "crawl": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 2.3,
                "brightness": 1,
                "flip": True,
                "frequency": 3.6,
                "mirror": False,
                "speed": 3.5,
            },
            "name": "Crawl",
        },
        "faded": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 6.4,
                "brightness": 1,
                "flip": True,
                "frequency": 5.9,
                "mirror": False,
                "speed": 9.7,
            },
            "name": "Faded",
        },
        "gentle": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 7.7,
                "brightness": 1,
                "flip": True,
                "frequency": 1.9,
                "mirror": True,
                "speed": 3.3,
            },
            "name": "Gentle",
        },
        "slow-roll": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "flip": True,
                "frequency": 4.4,
                "mirror": True,
                "speed": 1.1,
            },
            "name": "Slow Roll",
        },
    },
    "scroll": {
        "cold-crawl": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 1,
                "brightness": 1,
                "color_high": "#00ffff",
                "color_lows": "#ff00b2",
                "color_mids": "#ffb6c1",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "speed": 1,
                "threshold": 1,
            },
            "name": "Cold Crawl",
        },
        "dynamic-rgb": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 3,
                "brightness": 1,
                "color_high": "#0000ff",
                "color_lows": "#ff0000",
                "color_mids": "#00ff00",
                "decay": 0.97,
                "flip": False,
                "mirror": True,
                "speed": 5,
                "threshold": 0,
            },
            "name": "Dynamic RGB",
        },
        "fast-hits": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0.2,
                "brightness": 1,
                "color_high": "#ffa500",
                "color_lows": "#00ff7f",
                "color_mids": "#dda0dd",
                "decay": 0.9,
                "flip": False,
                "mirror": True,
                "speed": 6,
                "threshold": 0.6,
            },
            "name": "Fast Hits",
        },
        "gentle-rgb": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 7,
                "brightness": 1,
                "color_high": "#0000ff",
                "color_lows": "#ff0000",
                "color_mids": "#00ff00",
                "decay": 0.97,
                "flip": False,
                "frequency": 1.9,
                "mirror": True,
                "speed": 3,
                "threshold": 0,
            },
            "name": "Gentle RGB",
        },
        "icicles": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 1,
                "brightness": 1,
                "color_high": "#00ff32",
                "color_lows": "#add8e6",
                "color_mids": "#00ffff",
                "decay": 0.97,
                "flip": True,
                "mirror": False,
                "speed": 2,
                "threshold": 0.0215,
            },
            "name": "Icicles",
        },
        "rays": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color_high": "#00ffff",
                "color_lows": "#ffc800",
                "color_mids": "#ffc800",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "Rays",
        },
        "warmth": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 8.1,
                "brightness": 1,
                "color_high": "#00ff32",
                "color_lows": "#ff0000",
                "color_mids": "#ffa500",
                "decay": 0.97,
                "flip": False,
                "mirror": True,
                "speed": 8,
                "threshold": 0.55,
            },
            "name": "Warmth",
        },
    },
    "singleColor": {
        "blue": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color": "#0000ff",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "Blue",
        },
        "cyan": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color": "#00ffff",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "Cyan",
        },
        "green": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color": "#00ff00",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "Green",
        },
        "magenta": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color": "#ff00ff",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "Magenta",
        },
        "orange": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color": "#ffc800",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "Orange",
        },
        "pink": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color": "#ff00b2",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "#ff00b2",
        },
        "red": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color": "#ff0000",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "Red",
        },
        "red-waves": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 6.2,
                "brightness": 1,
                "color": "#ff0000",
                "flip": False,
                "mirror": True,
                "modulate": True,
                "modulation_effect": "sine",
                "modulation_speed": 0.76,
                "speed": 0.62,
            },
            "name": "Red Waves",
        },
        "steel-pulse": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 6.2,
                "brightness": 1,
                "color": "#4682b4",
                "flip": False,
                "mirror": True,
                "modulate": True,
                "modulation_effect": "breath",
                "modulation_speed": 0.75,
                "speed": 0.62,
            },
            "name": "Steel Pulse",
        },
        "turquoise-roll": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 6.2,
                "brightness": 1,
                "color": "#00c78c",
                "flip": False,
                "mirror": False,
                "modulate": True,
                "modulation_effect": "sine",
                "modulation_speed": 0.76,
                "speed": 0.62,
            },
            "name": "Turquoise Roll",
        },
        "yellow": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "blur": 0,
                "brightness": 1,
                "color": "#ffc800",
                "decay": 1,
                "flip": False,
                "mirror": True,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.5,
                "speed": 5,
                "threshold": 0.7,
            },
            "name": "Yellow",
        },
    },
    "strobe": {
        "aggro-red": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "beat_decay": 2,
                "blur": 6.2,
                "brightness": 1,
                "color": "#ff0000",
                "flip": False,
                "frequency": "1/4 (.o. )",
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "modulate": True,
                "modulation_effect": "sine",
                "modulation_speed": 0.76,
                "single_color": True,
                "speed": 0.62,
                "strobe_decay": 1.5,
                "strobe_frequency": "1/2 (.-. )",
            },
            "name": "Aggro Red",
        },
        "blues-on-the-beat": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "beat_decay": 2,
                "blur": 6.2,
                "brightness": 1,
                "color": "#0000ff",
                "flip": False,
                "frequency": "1/2 (.-. )",
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "modulate": True,
                "modulation_effect": "sine",
                "modulation_speed": 0.76,
                "single_color": True,
                "speed": 0.62,
                "strobe_decay": 1.5,
                "strobe_frequency": "1/2 (.-. )",
            },
            "name": "Blues on the Beat",
        },
        "fast-strobe": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "beat_decay": 2,
                "blur": 2.6,
                "brightness": 1,
                "color": "#ffffff",
                "flip": True,
                "frequency": "1/4 (.o. )",
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.76,
                "mirror": False,
                "single_color": False,
                "strobe_decay": 1.5,
                "strobe_frequency": "1/2 (.-. )",
            },
            "name": "Fast Strobe",
        },
        "faster-strobe": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "beat_decay": 2,
                "blur": 2.6,
                "brightness": 1,
                "color": "#ffffff",
                "flip": True,
                "frequency": "1/16 (◉﹏◉ )",
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "single_color": False,
                "strobe_decay": 1.5,
                "strobe_frequency": "1/2 (.-. )",
            },
            "name": "Faster Strobe",
        },
        "painful": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "beat_decay": 2,
                "blur": 2.6,
                "brightness": 1,
                "color": "#ffffff",
                "flip": True,
                "frequency": "1/32 (⊙▃⊙ )",
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "single_color": False,
                "strobe_decay": 1.5,
                "strobe_frequency": "1/2 (.-. )",
            },
            "name": "Painful",
        },
    },
    "wavelength": {
        "classic": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 3,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Rainbow",
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
            },
            "name": "Classic",
        },
        "greens": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 5.1,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Winter",
                "gradient": "linear-gradient(90deg, rgb(0, 199, 140) 0%, rgb(0, 255, 50) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": True,
            },
            "name": "Greens",
        },
        "icy": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 5.7,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Frost",
                "gradient": "linear-gradient(90deg, rgb(0, 0, 255) 0%, rgb(0, 255, 255) 33%, rgb(128, 0, 128) 66%, rgb(255, 0, 178) 99%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 1,
                "mirror": False,
            },
            "name": "Icy",
        },
        "plasma": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 1.8,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Plasma",
                "gradient": "linear-gradient(90deg, rgb(0, 0, 255) 0%, rgb(128, 0, 128) 25%, rgb(255, 0, 0) 50%, rgb(255, 40, 0) 75%, rgb(255, 200, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 6,
                "mirror": True,
            },
            "name": "Plasma",
        },
        "rolling-blues": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 1,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 3,
                "mirror": True,
            },
            "name": "rolling blues",
        },
        "rolling-warmth": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 5.9,
                "brightness": 1,
                "flip": False,
                "gradient_name": "Sunset",
                "gradient": "linear-gradient(90deg, rgb(0, 0, 128) 0%, rgb(255, 120, 0) 50%, rgb(255, 0, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 7,
                "mirror": True,
            },
            "name": "Rolling Warmth",
        },
        "sunset-sweep": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "blur": 8.6,
                "brightness": 1,
                "flip": True,
                "gradient_name": "Sunset",
                "gradient": "linear-gradient(90deg, rgb(0, 0, 128) 0%, rgb(255, 120, 0) 50%, rgb(255, 0, 0) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 4,
                "mirror": False,
            },
            "name": "Sunset Sweep",
        },
    },
    "real_strobe": {
        "dancefloor": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "bass_strobe_decay_rate": 0.7,
                "bass_threshold": 0.4,
                "blur": 0,
                "brightness": 1,
                "color_step": 0.0625,
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "strobe_color": "#ffffff",
                "strobe_decay_rate": 0.85,
                "strobe_width": 50,
            },
            "name": "Dance floor",
        },
        "strobe_only": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "bass_strobe_decay_rate": 0.7,
                "bass_threshold": 1,
                "blur": 0,
                "brightness": 1,
                "color_step": 0.0625,
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "strobe_color": "#ffffff",
                "strobe_decay_rate": 0.85,
                "strobe_width": 50,
            },
            "name": "Strobe only",
        },
        "bass_only": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "bass_strobe_decay_rate": 0.7,
                "bass_threshold": 0.4,
                "blur": 0,
                "brightness": 1,
                "color_step": 0.0625,
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "strobe_color": "#000000",
                "strobe_decay_rate": 0.85,
                "strobe_width": 0,
            },
            "name": "Bass only",
        },
        "extreme": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "bass_strobe_decay_rate": 1,
                "bass_threshold": 0.45,
                "blur": 0,
                "brightness": 1,
                "color_step": 0.0625,
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "strobe_color": "#ffffff",
                "strobe_decay_rate": 1,
                "strobe_width": 50,
            },
            "name": "Extreme",
        },
        "glitter": {
            "config": {
                "background_brightness": 1,
                "background_color": "#000000",
                "bass_strobe_decay_rate": 0.01,
                "bass_threshold": 0,
                "blur": 0,
                "brightness": 1,
                "color_step": 0.015,
                "flip": False,
                "gradient_name": "Dancefloor",
                "solid_color": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 0, 178) 50%, rgb(0, 0, 255) 100%)",
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": True,
                "strobe_color": "#ffffff",
                "strobe_decay_rate": 0.5,
                "strobe_width": 50,
            },
            "name": "Glitter",
        },
        "color-shift": {
            "config": {
                "background_brightness": 1.0,
                "background_color": "#000000",
                "bass_strobe_decay_rate": 0,
                "blur": 0.0,
                "brightness": 1.0,
                "color_shift_delay": 0.1,
                "color_step": 0.0625,
                "flip": False,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "gradient_roll": 0.0,
                "mirror": False,
                "strobe_color": "#000000",
                "strobe_decay_rate": 1,
                "strobe_width": 0,
            },
            "name": "Color shift",
        },
    },
    "blade_power_plus": {
        "orange-hi-hat": {
            "config": {
                "background_brightness": 0.3,
                "background_color": "#ffa500",
                "blur": 2,
                "brightness": 1,
                "color": "#00ffff",
                "color_correction": True,
                "decay": 0.7,
                "flip": False,
                "frequency_range": "High",
                "gradient": "linear-gradient(90deg, #ff00b2 0.00%,#ffa500 50.00%,#ffc800 100.00%)",
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": True,
                "multiplier": 1,
                "solid_color": False,
            },
            "name": "Orange HiHat",
        },
        "ocean-bass": {
            "config": {
                "background_brightness": 0.44,
                "background_color": "#0000ff",
                "blur": 2,
                "brightness": 1,
                "color": "#00ffff",
                "color_correction": True,
                "decay": 0.7,
                "flip": False,
                "frequency_range": "Lows (beat+bass)",
                "gradient": "linear-gradient(90deg, #00ffff 0.00%,#0000ff 100.00%)",
                "gradient_name": "Ocean",
                "gradient": "linear-gradient(90deg, rgb(0, 255, 255) 0%, rgb(0, 0, 255) 100%)",
                "solid_color": False,
                "gradient_repeat": 1,
                "gradient_roll": 0,
                "mirror": False,
                "multiplier": 0.5,
                "solid_color": False,
            },
            "name": "Ocean Bass",
        },
        "purplered-bass": {
            "config": {
                "blur": 2,
                "flip": False,
                "color": "#00ffff",
                "decay": 0.7,
                "mirror": False,
                "gradient": "#ff00b2",
                "brightness": 1,
                "multiplier": 0.5,
                "solid_color": False,
                "gradient_name": "Ocean",
                "gradient_roll": 0,
                "frequency_range": "Lows (beat+bass)",
                "gradient_repeat": 1,
                "background_color": "#ff0000",
                "color_correction": True,
                "background_brightness": 0.1,
            },
            "name": "PurpleRed Bass",
        },
    },
    "scan": {
        "painbow": {
            "config": {
                "advanced": True,
                "background_brightness": 0.0,
                "background_color": "#000000",
                "blur": 0.0,
                "bounce": False,
                "brightness": 1.0,
                "color_intensity": True,
                "color_scan": "#ff0000",
                "count": 2,
                "flip": False,
                "frequency_range": "Lows (beat+bass)",
                "full_grad": True,
                "gradient": "linear-gradient(90deg, rgb(255, 0, 0) 0%, rgb(255, 120, 0) 14%, rgb(255, 200, 0) 28%, rgb(0, 255, 0) 42%, rgb(0, 199, 140) 56%, rgb(0, 0, 255) 70%, rgb(128, 0, 128) 84%, rgb(255, 0, 178) 98%)",
                "gradient_roll": 1.0,
                "mirror": False,
                "modulate": False,
                "modulation_effect": "sine",
                "modulation_speed": 0.65,
                "multiplier": 3.0,
                "scan_width": 30,
                "speed": 31,
                "use_grad": True,
            },
            "name": "painbow",
        },
    },
    "melt": {
        "bladesmooth": {
            "name": "Blade Smooth",
            "config": {
                "background_brightness": 0.27,
                "flip": False,
                "background_color": "#0000ff",
                "brightness": 1,
                "gradient": "linear-gradient(90deg, #ff00b2 0.00%,#ffa500 50.00%,#ffc800 100.00%)",
                "reactivity": 0.3,
                "blur": 0,
                "mirror": False,
                "gradient_roll": 0,
                "speed": 0.2,
            },
        },
        "purple-red": {
            "name": "Purple Red",
            "config": {
                "blur": 0,
                "flip": False,
                "speed": 0.2,
                "mirror": False,
                "gradient": "linear-gradient(90deg, #ff00b2 0.00%,#ffa500 50.00%,#ffc800 100.00%)",
                "brightness": 1,
                "reactivity": 0.3,
                "gradient_roll": 0,
                "background_color": "#ff0000",
                "background_brightness": 0.3,
            },
        },
    },
    "gifplayer": {
        "dj-bird": {
            "config": {
                "gif_fps": 5,
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "resize_method": "Fastest",
                "blur": 0.0,
                "bounce": False,
                "brightness": 1.0,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "mirror": False,
                "pattern": False,
                "rotate": 0,
                "test": False,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "pixelart", "dj_bird.gif"
                ),
            },
            "name": "DJ Bird",
        },
        "rainbow-moon": {
            "config": {
                "gif_fps": 10,
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "resize_method": "Fastest",
                "blur": 0.0,
                "bounce": False,
                "brightness": 1.0,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "mirror": False,
                "pattern": False,
                "rotate": 0,
                "test": False,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "pixelart", "moon_rainbow.gif"
                ),
            },
            "name": "Rainbow Moon",
        },
        "fireworks": {
            "config": {
                "gif_fps": 10,
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "resize_method": "Fastest",
                "blur": 0.0,
                "bounce": False,
                "brightness": 1.0,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "mirror": False,
                "pattern": False,
                "rotate": 0,
                "test": False,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "pixelart", "fireworks.gif"
                ),
            },
            "name": "Fireworks",
        },
        "wled-akemi": {
            "config": {
                "gif_fps": 60,
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "resize_method": "Slow",
                "blur": 0.0,
                "bounce": True,
                "brightness": 1.0,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "mirror": False,
                "pattern": False,
                "rotate": 0,
                "test": False,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "pixelart", "akemi_resized.gif"
                ),
            },
            "name": "WLED Akemi",
        },
        # A little tribute to Shiraz, Tequila, Brandy, Reptar and Hulk
        # 2018 - 2023 😢
        "chicken": {
            "config": {
                "gif_fps": 5,
                "advanced": False,
                "background_brightness": 1.0,
                "background_color": "#000000",
                "resize_method": "Fastest",
                "blur": 0.0,
                "bounce": False,
                "brightness": 1.0,
                "diag": False,
                "dump": False,
                "flip": False,
                "flip_horizontal": False,
                "flip_vertical": False,
                "mirror": False,
                "pattern": False,
                "rotate": 0,
                "test": False,
                "image_location": os.path.join(
                    LEDFX_ASSETS_PATH, "gifs", "pixelart", "chicken.gif"
                ),
            },
            "name": "Chicken",
        },
    },
}
